/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="camera")
public class ServerEvents {
    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21205_().m_41720_().equals((Object)Main.CAMERA) || event.player.m_21206_().m_41720_().equals((Object)Main.CAMERA)) {
            return;
        }
        this.disableCamera(event.player.m_150109_().m_36056_());
        for (ItemStack stack : event.player.m_150109_().f_35974_) {
            this.disableCamera(stack);
        }
        for (ItemStack stack : event.player.m_150109_().f_35976_) {
            this.disableCamera(stack);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack item = player.m_21120_(hand);
            if (!item.m_41720_().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(item)) continue;
            event.setUseBlock(Event.Result.DENY);
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.EntityInteract event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    public void handleLeftClick(PlayerInteractEvent event) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = event.getPlayer().m_21120_(hand);
            if (!stack.m_41720_().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setCancellationResult(InteractionResult.PASS);
            break;
        }
    }

    @SubscribeEvent
    public void onHit(LivingAttackEvent event) {
        Entity source = event.getSource().m_7640_();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        this.disableCamera(event.getEntityItem().m_32055_());
    }

    private void disableCamera(ItemStack stack) {
        if (stack.m_41720_().equals((Object)Main.CAMERA)) {
            Main.CAMERA.setActive(stack, false);
        }
    }
}

